/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Objects;
import javax.sound.sampled.AudioFormat;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import noppes.npcs.LogWriter;
import noppes.npcs.api.NpcAPI;
import noppes.npcs.api.entity.IPlayer;
import noppes.npcs.api.event.ForgeEvent;
import noppes.npcs.api.mixin.client.audio.ILibraryMixin;
import noppes.npcs.api.mixin.client.audio.ISoundSystemMixin;
import paulscode.sound.Library;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystem;
import paulscode.sound.Source;

public class MusicData {
    public ISound sound;
    public String uuid;
    public Source source;
    public String name;
    public String resource;
    public float millitotal;

    public MusicData(ISound s, String id, SoundManager manager) {
        this.sound = s;
        this.uuid = id;
        this.name = "";
        this.resource = "";
        SoundSystem sndSystem = null;
        for (Field f : manager.getClass().getDeclaredFields()) {
            if (!f.getType().getName().contains("SoundSystem")) continue;
            try {
                f.setAccessible(true);
                sndSystem = (SoundSystem)f.get(manager);
            }
            catch (IllegalAccessException e) {
                LogWriter.debug(e.toString());
            }
            break;
        }
        if (sndSystem == null) {
            return;
        }
        Library soundLibrary = ((ISoundSystemMixin)sndSystem).npcs$getSoundLibrary();
        HashMap<String, Source> sourceMap = ((ILibraryMixin)soundLibrary).npcs$getSourceMap();
        if (sourceMap != null) {
            this.source = sourceMap.get(id);
            if (s != null) {
                this.name = s.func_147650_b().toString();
                s.func_184364_b();
                this.resource = this.sound.func_184364_b().func_188719_a().toString();
            }
            this.millitotal = 0.0f;
            if (this.source != null && this.source.soundBuffer != null) {
                SoundBuffer buffer = this.source.soundBuffer;
                AudioFormat format = buffer.audioFormat;
                float frames = (float)buffer.audioData.length / (float)format.getFrameSize();
                this.millitotal = 1000.0f * frames / format.getFrameRate();
                if (this.name.indexOf("minecraft") == 0) {
                    this.millitotal *= 300.0f;
                }
            }
        }
    }

    public ForgeEvent.SoundTickEvent createEvent(EntityPlayer player) {
        float volume = 1.0f;
        float pitch = 1.0f;
        float milliseconds = 0.0f;
        int[] pos = new int[]{0, 0, 0};
        if (this.sound != null) {
            volume = this.sound.func_147653_e();
            pitch = this.sound.func_147655_f();
            pos[0] = (int)this.sound.func_147649_g();
            pos[1] = (int)this.sound.func_147654_h();
            pos[2] = (int)this.sound.func_147651_i();
        }
        if (this.source != null) {
            milliseconds = this.source.millisecondsPlayed();
            pos[0] = (int)this.source.position.x;
            pos[1] = (int)this.source.position.y;
            pos[2] = (int)this.source.position.z;
            if (this.millitotal == 0.0f && this.source.soundBuffer != null) {
                SoundBuffer buffer = this.source.soundBuffer;
                AudioFormat format = buffer.audioFormat;
                float frames = (float)buffer.audioData.length / (float)format.getFrameSize();
                this.millitotal = 1000.0f * frames / format.getFrameRate();
                if (this.name.indexOf("minecraft") == 0) {
                    this.millitotal *= 300.0f;
                }
            }
        }
        return new ForgeEvent.SoundTickEvent((IPlayer)Objects.requireNonNull(NpcAPI.Instance()).getIEntity((Entity)player), this.name, this.resource, Objects.requireNonNull(NpcAPI.Instance()).getIPos(pos[0], pos[1], pos[2]), volume, pitch, milliseconds, this.millitotal);
    }
}

